/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import lotr.common.LOTRCapes;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDate;
import lotr.common.LOTRGreyWandererTracker;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRShields;
import lotr.common.LOTRSpawnDamping;
import lotr.common.fellowship.LOTRFellowship;
import lotr.common.fellowship.LOTRFellowshipData;
import lotr.common.network.LOTRPacketAlignment;
import lotr.common.network.LOTRPacketCape;
import lotr.common.network.LOTRPacketEnableAlignmentZones;
import lotr.common.network.LOTRPacketFTCooldown;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketLogin;
import lotr.common.network.LOTRPacketPortalPos;
import lotr.common.network.LOTRPacketShield;
import lotr.common.network.LOTRPacketUpdatePlayerLocations;
import lotr.common.world.spawning.LOTREventSpawner;
import lotr.common.world.spawning.LOTRTravellingTraderSpawner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;

public class LOTRLevelData {
    public static int madePortal;
    public static int madeMiddleEarthPortal;
    public static int overworldPortalX;
    public static int overworldPortalY;
    public static int overworldPortalZ;
    public static int middleEarthPortalX;
    public static int middleEarthPortalY;
    public static int middleEarthPortalZ;
    private static int structuresBanned;
    private static int waypointCooldownMax;
    private static int waypointCooldownMin;
    private static boolean gollumSpawned;
    private static boolean balrogSpawned;
    private static boolean enableAlignmentZones;
    private static float conquestRate;
    public static boolean clientside_thisServer_feastMode;
    public static boolean clientside_thisServer_fellowshipCreation;
    public static boolean clientside_thisServer_enchanting;
    public static boolean clientside_thisServer_strictFactionTitleRequirements;
    public static boolean clientside_thisServer_enchantingLOTR;
    public static boolean clientside_enableNPCHiringLimit;
    public static int clientside_defaultNPCHiringLimit;
    private static EnumDifficulty difficulty;
    private static boolean difficultyLock;
    private static Map<UUID, LOTRPlayerData> playerDataMap;
    public static boolean needsLoad;
    private static boolean needsSave;
    private static Random rand;

    public static void markDirty() {
        needsSave = true;
    }

    public static boolean anyDataNeedsSave() {
        if (needsSave) {
            return true;
        }
        if (LOTRSpawnDamping.needsSave) {
            return true;
        }
        for (LOTRPlayerData pd : playerDataMap.values()) {
            if (!pd.needsSave()) continue;
            return true;
        }
        return false;
    }

    public static File getOrCreateLOTRDir() {
        File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "LOTR");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private static File getLOTRDat() {
        return new File(LOTRLevelData.getOrCreateLOTRDir(), "LOTR.dat");
    }

    private static File getLOTRPlayerDat(UUID player) {
        File playerDir = new File(LOTRLevelData.getOrCreateLOTRDir(), "players");
        if (!playerDir.exists()) {
            playerDir.mkdirs();
        }
        return new File(playerDir, player.toString() + ".dat");
    }

    public static NBTTagCompound loadNBTFromFile(File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        return new NBTTagCompound();
    }

    public static void saveNBTToFile(File file, NBTTagCompound nbt) throws FileNotFoundException, IOException {
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(file));
    }

    public static void save() {
        try {
            if (needsSave) {
                File LOTR_dat = LOTRLevelData.getLOTRDat();
                if (LOTR_dat == null) {
                    throw new FileNotFoundException("LOTR data file not found.");
                }
                if (!LOTR_dat.exists()) {
                    LOTRLevelData.saveNBTToFile(LOTR_dat, new NBTTagCompound());
                }
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("MadePortal", madePortal);
                nBTTagCompound.func_74768_a("MadeMiddlePortal", madeMiddleEarthPortal);
                nBTTagCompound.func_74768_a("OverworldX", overworldPortalX);
                nBTTagCompound.func_74768_a("OverworldY", overworldPortalY);
                nBTTagCompound.func_74768_a("OverworldZ", overworldPortalZ);
                nBTTagCompound.func_74768_a("MiddleEarthX", middleEarthPortalX);
                nBTTagCompound.func_74768_a("MiddleEarthY", middleEarthPortalY);
                nBTTagCompound.func_74768_a("MiddleEarthZ", middleEarthPortalZ);
                nBTTagCompound.func_74768_a("StructuresBanned", structuresBanned);
                nBTTagCompound.func_74768_a("WpCdMax", waypointCooldownMax);
                nBTTagCompound.func_74768_a("WpCdMin", waypointCooldownMin);
                nBTTagCompound.func_74757_a("GollumSpawned", gollumSpawned);
                nBTTagCompound.func_74757_a("BalrogSpawned", balrogSpawned);
                nBTTagCompound.func_74757_a("AlignmentZones", enableAlignmentZones);
                nBTTagCompound.func_74776_a("ConqRate", conquestRate);
                if (difficulty != null) {
                    nBTTagCompound.func_74768_a("SavedDifficulty", difficulty.func_151525_a());
                }
                nBTTagCompound.func_74757_a("DifficultyLock", difficultyLock);
                NBTTagCompound travellingTraderData = new NBTTagCompound();
                for (LOTRTravellingTraderSpawner trader : LOTREventSpawner.travellingTraders) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    trader.writeToNBT(nbt);
                    travellingTraderData.func_74782_a(trader.entityClassName, (NBTBase)nbt);
                }
                nBTTagCompound.func_74782_a("TravellingTraders", (NBTBase)travellingTraderData);
                LOTRGreyWandererTracker.save(nBTTagCompound);
                LOTRDate.saveDates(nBTTagCompound);
                LOTRLevelData.saveNBTToFile(LOTR_dat, nBTTagCompound);
                needsSave = false;
            }
            for (Map.Entry entry : playerDataMap.entrySet()) {
                UUID player = (UUID)entry.getKey();
                LOTRPlayerData pd = (LOTRPlayerData)entry.getValue();
                if (pd == null || !pd.needsSave()) continue;
                LOTRLevelData.saveData(player);
            }
            if (LOTRSpawnDamping.needsSave) {
                LOTRSpawnDamping.saveAll();
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error saving LOTR data", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void load() {
        try {
            NBTTagCompound nbt;
            File lotrDat = LOTRLevelData.getLOTRDat();
            if (lotrDat == null) {
                throw new FileNotFoundException("LOTR data file not found.");
            }
            NBTTagCompound levelData = LOTRLevelData.loadNBTFromFile(lotrDat);
            if (levelData == null) {
                throw new IOException("Failed to load LOTR data.");
            }
            File oldLOTRDat = new File(DimensionManager.getCurrentSaveRootDirectory(), "LOTR.dat");
            if (oldLOTRDat.exists()) {
                NBTTagCompound oldLevelData = LOTRLevelData.loadNBTFromFile(oldLOTRDat);
                oldLOTRDat.delete();
                if (oldLevelData.func_74764_b("PlayerData")) {
                    NBTTagList playerDataTags = oldLevelData.func_150295_c("PlayerData", 10);
                    for (int i = 0; i < playerDataTags.func_74745_c(); ++i) {
                        nbt = playerDataTags.func_150305_b(i);
                        UUID player = UUID.fromString(nbt.func_74779_i("PlayerUUID"));
                        LOTRLevelData.saveNBTToFile(LOTRLevelData.getLOTRPlayerDat(player), nbt);
                    }
                }
            }
            madePortal = levelData.func_74762_e("MadePortal");
            madeMiddleEarthPortal = levelData.func_74762_e("MadeMiddlePortal");
            overworldPortalX = levelData.func_74762_e("OverworldX");
            overworldPortalY = levelData.func_74762_e("OverworldY");
            overworldPortalZ = levelData.func_74762_e("OverworldZ");
            middleEarthPortalX = levelData.func_74762_e("MiddleEarthX");
            middleEarthPortalY = levelData.func_74762_e("MiddleEarthY");
            middleEarthPortalZ = levelData.func_74762_e("MiddleEarthZ");
            structuresBanned = levelData.func_74762_e("StructuresBanned");
            int n = levelData.func_74764_b("FastTravel") ? levelData.func_74762_e("FastTravel") / 20 : (waypointCooldownMax = levelData.func_74764_b("WpCdMax") ? levelData.func_74762_e("WpCdMax") : 1800);
            waypointCooldownMin = levelData.func_74764_b("FastTravelMin") ? levelData.func_74762_e("FastTravelMin") / 20 : (levelData.func_74764_b("WpCdMin") ? levelData.func_74762_e("WpCdMin") : 180);
            gollumSpawned = levelData.func_74767_n("GollumSpawned");
            balrogSpawned = levelData.func_74767_n("BalrogSpawned");
            enableAlignmentZones = levelData.func_74764_b("AlignmentZones") ? levelData.func_74767_n("AlignmentZones") : true;
            float f = conquestRate = levelData.func_74764_b("ConqRate") ? levelData.func_74760_g("ConqRate") : 1.0f;
            if (levelData.func_74764_b("SavedDifficulty")) {
                int id = levelData.func_74762_e("SavedDifficulty");
                difficulty = EnumDifficulty.func_151523_a((int)id);
                LOTRMod.proxy.setClientDifficulty(difficulty);
            } else {
                difficulty = null;
            }
            difficultyLock = levelData.func_74767_n("DifficultyLock");
            NBTTagCompound travellingTraderData = levelData.func_74775_l("TravellingTraders");
            for (LOTRTravellingTraderSpawner trader : LOTREventSpawner.travellingTraders) {
                if (!travellingTraderData.func_74764_b(trader.entityClassName)) continue;
                nbt = travellingTraderData.func_74775_l(trader.entityClassName);
                trader.readFromNBT(nbt);
            }
            LOTRGreyWandererTracker.load(levelData);
            LOTRLevelData.destroyAllPlayerData();
            LOTRDate.loadDates(levelData);
            LOTRSpawnDamping.loadAll();
            needsLoad = false;
            needsSave = true;
            LOTRLevelData.save();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error loading LOTR data", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void setMadePortal(int i) {
        madePortal = i;
        LOTRLevelData.markDirty();
    }

    public static void setMadeMiddleEarthPortal(int i) {
        madeMiddleEarthPortal = i;
        LOTRLevelData.markDirty();
    }

    public static void markOverworldPortalLocation(int i, int j, int k) {
        overworldPortalX = i;
        overworldPortalY = j;
        overworldPortalZ = k;
        LOTRLevelData.markDirty();
    }

    public static void markMiddleEarthPortalLocation(int i, int j, int k) {
        LOTRPacketPortalPos packet = new LOTRPacketPortalPos(i, j, k);
        LOTRPacketHandler.networkWrapper.sendToAll((IMessage)packet);
        LOTRLevelData.markDirty();
    }

    public static void sendLoginPacket(EntityPlayerMP entityplayer) {
        LOTRPacketLogin packet = new LOTRPacketLogin();
        packet.ringPortalX = middleEarthPortalX;
        packet.ringPortalY = middleEarthPortalY;
        packet.ringPortalZ = middleEarthPortalZ;
        packet.ftCooldownMax = waypointCooldownMax;
        packet.ftCooldownMin = waypointCooldownMin;
        packet.fellowshipCreation = LOTRConfig.enableFellowshipCreation;
        packet.difficulty = difficulty;
        packet.difficultyLocked = difficultyLock;
        packet.alignmentZones = enableAlignmentZones;
        packet.feastMode = LOTRConfig.canAlwaysEat;
        packet.enchanting = LOTRConfig.enchantingVanilla;
        packet.enchantingLOTR = LOTRConfig.enchantingLOTR;
        packet.strictFactionTitleRequirements = LOTRConfig.strictFactionTitleRequirements;
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
        packet.enableNPCHiringLimit = LOTRConfig.getEnableNPCHiringLimit();
        packet.defaultNPCHiringLimit = LOTRConfig.getDefaultNPCHiringLimit();
    }

    public static int getWaypointCooldownMax() {
        return waypointCooldownMax;
    }

    public static int getWaypointCooldownMin() {
        return waypointCooldownMin;
    }

    public static void setWaypointCooldown(int max, int min) {
        max = Math.max(0, max);
        if ((min = Math.max(0, min)) > max) {
            min = max;
        }
        waypointCooldownMax = max;
        waypointCooldownMin = min;
        LOTRLevelData.markDirty();
        if (!LOTRMod.proxy.isClient()) {
            List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            for (Object player : players) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)player;
                LOTRPacketFTCooldown packet = new LOTRPacketFTCooldown(waypointCooldownMax, waypointCooldownMin);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
            }
        }
    }

    public static boolean enableAlignmentZones() {
        return enableAlignmentZones;
    }

    public static void setEnableAlignmentZones(boolean flag) {
        enableAlignmentZones = flag;
        LOTRLevelData.markDirty();
        if (!LOTRMod.proxy.isClient()) {
            List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            for (Object player : players) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)player;
                LOTRPacketEnableAlignmentZones packet = new LOTRPacketEnableAlignmentZones(enableAlignmentZones);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
            }
        }
    }

    public static float getConquestRate() {
        return conquestRate;
    }

    public static void setConquestRate(float f) {
        conquestRate = f;
        LOTRLevelData.markDirty();
    }

    public static void sendPlayerData(EntityPlayerMP entityplayer) {
        try {
            LOTRPlayerData pd = LOTRLevelData.getData((EntityPlayer)entityplayer);
            pd.sendPlayerData(entityplayer);
        }
        catch (Exception e) {
            FMLLog.severe((String)("Failed to send player data to player " + entityplayer.func_70005_c_()), (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static LOTRPlayerData getData(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer.func_110124_au());
    }

    public static LOTRPlayerData getData(UUID player) {
        LOTRPlayerData pd = playerDataMap.get(player);
        if (pd == null) {
            pd = LOTRLevelData.loadData(player);
            if (pd == null) {
                pd = new LOTRPlayerData(player);
            }
            playerDataMap.put(player, pd);
        }
        return pd;
    }

    private static LOTRPlayerData loadData(UUID player) {
        try {
            NBTTagCompound nbt = LOTRLevelData.loadNBTFromFile(LOTRLevelData.getLOTRPlayerDat(player));
            LOTRPlayerData pd = new LOTRPlayerData(player);
            pd.load(nbt);
            return pd;
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error loading LOTR player data for %s", (Object[])new Object[]{player});
            e.printStackTrace();
            return null;
        }
    }

    public static void saveData(UUID player) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            LOTRPlayerData pd = playerDataMap.get(player);
            pd.save(nbt);
            LOTRLevelData.saveNBTToFile(LOTRLevelData.getLOTRPlayerDat(player), nbt);
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error saving LOTR player data for %s", (Object[])new Object[]{player});
            e.printStackTrace();
        }
    }

    private static boolean saveAndClearData(UUID player) {
        LOTRPlayerData pd = playerDataMap.get(player);
        if (pd != null) {
            boolean saved = false;
            if (pd.needsSave()) {
                LOTRLevelData.saveData(player);
                saved = true;
            }
            playerDataMap.remove(player);
            return saved;
        }
        FMLLog.severe((String)"Attempted to clear LOTR player data for %s; no data found", (Object[])new Object[]{player});
        return false;
    }

    public static void saveAndClearUnusedPlayerData() {
        ArrayList<UUID> clearing = new ArrayList<UUID>();
        for (UUID player : playerDataMap.keySet()) {
            boolean foundPlayer = false;
            for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                if (world.func_152378_a(player) == null) continue;
                foundPlayer = true;
                break;
            }
            if (foundPlayer) continue;
            clearing.add(player);
        }
        clearing.size();
        playerDataMap.size();
        for (UUID player : clearing) {
            boolean saved = LOTRLevelData.saveAndClearData(player);
            if (saved) continue;
        }
        playerDataMap.size();
    }

    public static void destroyAllPlayerData() {
        playerDataMap.clear();
    }

    public static boolean structuresBanned() {
        return structuresBanned == 1;
    }

    public static void setStructuresBanned(boolean banned) {
        structuresBanned = banned ? 1 : 0;
        LOTRLevelData.markDirty();
    }

    public static void setPlayerBannedForStructures(String username, boolean flag) {
        UUID uuid = UUID.fromString(PreYggdrasilConverter.func_152719_a((String)username));
        if (uuid != null) {
            LOTRLevelData.getData(uuid).setStructuresBanned(flag);
        }
    }

    public static boolean isPlayerBannedForStructures(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getStructuresBanned();
    }

    public static Set<String> getBannedStructurePlayersUsernames() {
        HashSet<String> players = new HashSet<String>();
        for (UUID uuid : playerDataMap.keySet()) {
            String username;
            if (!LOTRLevelData.getData(uuid).getStructuresBanned()) continue;
            GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(uuid);
            if (StringUtils.isBlank((CharSequence)profile.getName())) {
                MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(profile, true);
            }
            if (StringUtils.isBlank((CharSequence)(username = profile.getName()))) continue;
            players.add(username);
        }
        return players;
    }

    public static void sendAlignmentToAllPlayersInWorld(EntityPlayer entityplayer, World world) {
        for (Object element : world.field_73010_i) {
            EntityPlayer worldPlayer = (EntityPlayer)element;
            LOTRPacketAlignment packet = new LOTRPacketAlignment(entityplayer.func_110124_au());
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)worldPlayer);
        }
    }

    public static void sendAllAlignmentsInWorldToPlayer(EntityPlayer entityplayer, World world) {
        for (Object element : world.field_73010_i) {
            EntityPlayer worldPlayer = (EntityPlayer)element;
            LOTRPacketAlignment packet = new LOTRPacketAlignment(worldPlayer.func_110124_au());
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public static void selectDefaultShieldForPlayer(EntityPlayer entityplayer) {
        if (LOTRLevelData.getData(entityplayer).getShield() == null) {
            for (LOTRShields shield : LOTRShields.values()) {
                if (!shield.canPlayerWear(entityplayer)) continue;
                LOTRLevelData.getData(entityplayer).setShield(shield);
                return;
            }
        }
    }

    public static void sendShieldToAllPlayersInWorld(EntityPlayer entityplayer, World world) {
        for (Object element : world.field_73010_i) {
            EntityPlayer worldPlayer = (EntityPlayer)element;
            LOTRPacketShield packet = new LOTRPacketShield(entityplayer.func_110124_au());
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)worldPlayer);
        }
    }

    public static void sendAllShieldsInWorldToPlayer(EntityPlayer entityplayer, World world) {
        for (Object element : world.field_73010_i) {
            EntityPlayer worldPlayer = (EntityPlayer)element;
            LOTRPacketShield packet = new LOTRPacketShield(worldPlayer.func_110124_au());
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public static void selectDefaultCapeForPlayer(EntityPlayer entityplayer) {
        if (LOTRLevelData.getData(entityplayer).getCape() == null) {
            LOTRCapes[] arrayOfLOTRCapes = LOTRCapes.values();
            int i = arrayOfLOTRCapes.length;
            for (int b = 0; b < i; b = (int)((byte)(b + 1))) {
                LOTRCapes cape = arrayOfLOTRCapes[b];
                if (!cape.canPlayerWearCape(entityplayer)) {
                    continue;
                }
                LOTRLevelData.getData(entityplayer).setCape(cape);
                return;
            }
        }
    }

    public static void sendCapeToAllPlayersInWorld(EntityPlayer entityplayer, World world) {
        for (Object element : world.field_73010_i) {
            EntityPlayer worldPlayer = (EntityPlayer)element;
            LOTRPacketCape packet = new LOTRPacketCape(entityplayer.func_110124_au());
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)worldPlayer);
        }
    }

    public static void sendAllCapesInWorldToPlayer(EntityPlayer entityplayer, World world) {
        for (Object element : world.field_73010_i) {
            EntityPlayer worldPlayer = (EntityPlayer)element;
            LOTRPacketCape packet = new LOTRPacketCape(worldPlayer.func_110124_au());
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
        }
    }

    public static void sendPlayerLocationsToPlayer(EntityPlayer sendPlayer, World world) {
        LOTRPacketUpdatePlayerLocations packetLocations = new LOTRPacketUpdatePlayerLocations();
        boolean isOp = MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(sendPlayer.func_146103_bH());
        boolean creative = sendPlayer.field_71075_bZ.field_75098_d;
        LOTRPlayerData playerData = LOTRLevelData.getData(sendPlayer);
        ArrayList<LOTRFellowship> fellowshipsMapShow = new ArrayList<LOTRFellowship>();
        for (UUID fsID : playerData.getFellowshipIDs()) {
            LOTRFellowship fs = LOTRFellowshipData.getFellowship(fsID);
            if (fs == null || fs.isDisbanded() || !fs.getShowMapLocations()) continue;
            fellowshipsMapShow.add(fs);
        }
        for (UUID element : world.field_73010_i) {
            boolean show;
            EntityPlayer otherPlayer = (EntityPlayer)element;
            if (otherPlayer == sendPlayer) continue;
            boolean bl = show = !LOTRLevelData.getData(otherPlayer).getHideMapLocation();
            if (!isOp && LOTRLevelData.getData(otherPlayer).getAdminHideMap() || LOTRConfig.forceMapLocations == 1) {
                show = false;
            } else if (LOTRConfig.forceMapLocations == 2) {
                show = true;
            } else if (!show) {
                if (isOp && creative) {
                    show = true;
                } else if (!playerData.isSiegeActive()) {
                    for (LOTRFellowship fs : fellowshipsMapShow) {
                        if (!fs.containsPlayer(otherPlayer.func_110124_au())) continue;
                        show = true;
                        break;
                    }
                }
            }
            if (!show) continue;
            packetLocations.addPlayerLocation(otherPlayer.func_146103_bH(), otherPlayer.field_70165_t, otherPlayer.field_70161_v);
        }
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packetLocations, (EntityPlayerMP)sendPlayer);
    }

    public static boolean gollumSpawned() {
        return gollumSpawned;
    }

    public static void setGollumSpawned(boolean flag) {
        gollumSpawned = flag;
        LOTRLevelData.markDirty();
    }

    public static boolean balrogSpawned() {
        return balrogSpawned;
    }

    public static void setBalrogSpawned(boolean flag) {
        balrogSpawned = flag;
        LOTRLevelData.markDirty();
    }

    public static EnumDifficulty getSavedDifficulty() {
        return difficulty;
    }

    public static void setSavedDifficulty(EnumDifficulty d) {
        difficulty = d;
        LOTRLevelData.markDirty();
    }

    public static boolean isDifficultyLocked() {
        return difficultyLock;
    }

    public static void setDifficultyLocked(boolean flag) {
        difficultyLock = flag;
        LOTRLevelData.markDirty();
    }

    public static String getHMSTime_Seconds(int secs) {
        return LOTRLevelData.getHMSTime_Ticks(secs * 20);
    }

    public static String getHMSTime_Ticks(int ticks) {
        int hours = ticks / 72000;
        int minutes = ticks % 72000 / 1200;
        int seconds = ticks % 72000 % 1200 / 20;
        String sHours = StatCollector.func_74837_a((String)"lotr.gui.time.hours", (Object[])new Object[]{hours});
        String sMinutes = StatCollector.func_74837_a((String)"lotr.gui.time.minutes", (Object[])new Object[]{minutes});
        String sSeconds = StatCollector.func_74837_a((String)"lotr.gui.time.seconds", (Object[])new Object[]{seconds});
        if (hours > 0) {
            return StatCollector.func_74837_a((String)"lotr.gui.time.format.hms", (Object[])new Object[]{sHours, sMinutes, sSeconds});
        }
        if (minutes > 0) {
            return StatCollector.func_74837_a((String)"lotr.gui.time.format.ms", (Object[])new Object[]{sMinutes, sSeconds});
        }
        return StatCollector.func_74837_a((String)"lotr.gui.time.format.s", (Object[])new Object[]{sSeconds});
    }

    static {
        conquestRate = 1.0f;
        difficultyLock = false;
        playerDataMap = new HashMap<UUID, LOTRPlayerData>();
        needsLoad = true;
        needsSave = false;
        rand = new Random();
    }
}

